grammar RelationalAlgebra;
prog:	expr + '.'EOF 
	|	ID + '.'EOF 
	|	'.'EOF 
;
expr:	operator + '('+ arg + ')'
	| 	ordfunc
    ;
ordfunc: 	'VTOA(' + rules + ',' + ID + ')' 
		|	'VTOA(' + rules + ',' + expr + ')'
		|   'ATOV(' + rules + ',' + ID + ')'
		|	'ATOV(' + rules + ',' + expr + ')'
;
rules:	SMID + '(' arg + ')'
;
operator:	'JOIN'
		|	'ANTI JOIN'
		|	'UNION' 
		|	'INTERSECTION'
		|	'ASSIGNMENT'
;
arg:	expr
	|   arg ',' arg
	|	ID
;
NEWLINE : [\r\n]+ -> skip;
ID 		: [A-Z0-9_-]+; 
SMID	: [a-z0-9_-]+;
